/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.cec;

import com.ibm.hsc.auiml.databeans.cec.CECPropertyBean;
import com.ibm.hsc.auiml.databeans.cec.CecSrcBean;
import com.ibm.hsc.auiml.databeans.common.TreeTableDisplay;
import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.SRCEntry;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.AuimlAdapter;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.ErrorPanel;
import com.ibm.hsc.common.util.GeneralUtil;
import com.ibm.hsc.common.util.HMCDynamicPanelManager;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HscEAccess;
import com.ibm.hsc.common.util.InfoPanel;
import com.ibm.hsc.websm.frame.CSPStateText;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.ValueDescriptor;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.mobject.MOClass;
import com.ibm.websm.mobject.MOXContainerObj;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class CECPropertyDialog {
    public static final String SRC_FUNC = "getSRCEntry";
    public static final String SRC_TABLE = "SRCPanel.SRCTable";
    private static Properties properties = null;
    public static boolean debug;
    private static String TRUE;
    private static String FALSE;
    private static String[] KEYS;
    static /* synthetic */ Class class$com$ibm$hsc$websm$cec$CECPropertyDialog;

    public static void showDialog(MOXContainerObj mOXContainerObj) {
        CECPropertyBean cECPropertyBean = new CECPropertyBean();
        CecSrcBean cecSrcBean = new CecSrcBean();
        boolean bl = false;
        cecSrcBean.load();
        cECPropertyBean.load();
        cECPropertyBean.setMOXContainerObj(mOXContainerObj);
        TRUE = HSCResourceBundleUtil.getMessage("ProfileBundle", "TRUE");
        FALSE = HSCResourceBundleUtil.getMessage("ProfileBundle", "FALSE");
        try {
            Object object;
            String string;
            AuimlAdapter auimlAdapter;
            block10: {
                DataBean[] dataBeanArray = new DataBean[]{cECPropertyBean, cecSrcBean};
                HMCDynamicPanelManager.setMetalLookAndFeel();
                auimlAdapter = new AuimlAdapter("com.ibm.hsc.auiml.databeans.cec.CECProperties", properties, "CECPropertiesMainPanel", dataBeanArray, null, null, (class$com$ibm$hsc$websm$cec$CECPropertyDialog == null ? (class$com$ibm$hsc$websm$cec$CECPropertyDialog = CECPropertyDialog.class$("com.ibm.hsc.websm.cec.CECPropertyDialog")) : class$com$ibm$hsc$websm$cec$CECPropertyDialog).getClassLoader());
                string = MessageFormat.format(HSCResourceBundleUtil.getMessage("CECBundle", "CEC_PROPERTY_DIALOG_TITLE", "CEC {0} Property Dialog"), mOXContainerObj.getName());
                if (mOXContainerObj == null) {
                    CECPropertyDialog.debugThis(" CEC Container Obj is null");
                    string = HSCResourceBundleUtil.getMessage("CECBundle", "CEC_PROPERTY_DIALOG_ERROR_TITLE");
                    String string2 = HSCResourceBundleUtil.getMessage("CECBundle", "NO_OBJECT_INFORMATION");
                    new ErrorPanel("Error bringing up CEC Property Dialog", string).show();
                    return;
                }
                auimlAdapter.addTaskSelectionListener(cecSrcBean, SRC_TABLE);
                auimlAdapter.addTaskActionListener(cecSrcBean);
                auimlAdapter.addTaskActionListener(cECPropertyBean);
                auimlAdapter.setCaptionText("CECPropertiesMainPanel", string);
                auimlAdapter.setShown("MemoryPanel.HypCurMemoryLabel", false);
                auimlAdapter.setShown("MemoryPanel.HypMaxMemoryLabel", false);
                auimlAdapter.setShown("MemoryPanel.HypMinMemoryLabel", false);
                try {
                    object = (Integer)mOXContainerObj.getPropertyValue("state_PROP");
                    if (object != null && (Integer)object == 3) {
                        bl = false;
                        cECPropertyBean.setIsCECPoweredOff(true);
                        cECPropertyBean.setCECName(mOXContainerObj.getName());
                        auimlAdapter.removeGroup("ProcessorPanel");
                        auimlAdapter.removeGroup("IOSlotPanel");
                        auimlAdapter.removeGroup("MemoryPanel");
                    } else {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    if (!IDebug.enabled) break block10;
                    exception.printStackTrace();
                }
            }
            object = CECPropertyDialog.setBeanInfo(cECPropertyBean, cecSrcBean, mOXContainerObj, auimlAdapter, bl);
            if (!HscEAccess.checkAccess("CECMObjActDispInfo", "CECModify", mOXContainerObj.getMOClass().getHost().getName())) {
                auimlAdapter.setEnabled("CECPropertiesMainPanel", false);
            }
            auimlAdapter.showIt();
            if (((String)object).length() > 0) {
                string = HSCResourceBundleUtil.getMessage("CECBundle", "CEC_PROPERTY_DIALOG_WARNING_TITLE");
                object = MessageFormat.format(HSCResourceBundleUtil.getMessage("CECBundle", "FOLLOWING_ERROR"), object);
                new InfoPanel((String)object, string, "").show();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = exception.getMessage();
            String string3 = HSCResourceBundleUtil.getMessage("CECBundle", "CEC_PROPERTY_DIALOG_ERROR_TITLE");
            if (string != null) {
                string = MessageFormat.format(HSCResourceBundleUtil.getMessage("CECBundle", "FOLLOWING_ERROR"), string);
            }
            new ErrorPanel(string, string3).show();
        }
    }

    public static void main(String[] stringArray) {
        CECPropertyDialog cECPropertyDialog = new CECPropertyDialog();
        CECPropertyDialog.showDialog(null);
    }

    private static String setBeanInfo(CECPropertyBean cECPropertyBean, CecSrcBean cecSrcBean, MOXContainerObj mOXContainerObj, AuimlAdapter auimlAdapter, boolean bl) {
        String string = "";
        try {
            block24: {
                PICECDataBean pICECDataBean;
                block23: {
                    Hashtable hashtable;
                    block22: {
                        block21: {
                            block20: {
                                block19: {
                                    hashtable = (Hashtable)CECPropertyDialog.getObjectFromMethod("getCECPropertyHashtable", mOXContainerObj);
                                    pICECDataBean = (PICECDataBean)hashtable.get("cecdatabean");
                                    if (bl) {
                                        if (pICECDataBean.isOS400Capable() && pICECDataBean.getMaxI5OSProcUnits().intValue() != 0) {
                                            auimlAdapter.setShown("ProcessorPanel.MaximumI5OSProcsLabel", true);
                                        } else {
                                            auimlAdapter.setShown("ProcessorPanel.MaximumI5OSProcsLabel", false);
                                        }
                                    }
                                    cECPropertyBean.setCECDataBean(pICECDataBean);
                                    try {
                                        CECPropertyDialog.setGeneralPanelElements(mOXContainerObj, cECPropertyBean, pICECDataBean, auimlAdapter, hashtable);
                                    }
                                    catch (Exception exception) {
                                        CECPropertyDialog.debugThis("Failed to setGeneralPanelElements");
                                        string = CECPropertyDialog.addMessage(string, exception);
                                        if (!IDebug.enabled) break block19;
                                        exception.printStackTrace();
                                    }
                                }
                                try {
                                    CECPropertyDialog.setIPLPanelElements(cECPropertyBean, pICECDataBean, auimlAdapter);
                                }
                                catch (Throwable throwable) {
                                    string = CECPropertyDialog.addMessage(string, throwable);
                                    CECPropertyDialog.debugThis("Failed to set IPL Parameters");
                                    if (!IDebug.enabled) break block20;
                                    throwable.printStackTrace();
                                }
                            }
                            try {
                                CECPropertyDialog.setSRCPanelElements(cecSrcBean, mOXContainerObj, auimlAdapter);
                            }
                            catch (Throwable throwable) {
                                string = CECPropertyDialog.addMessage(string, throwable);
                                CECPropertyDialog.debugThis("Failed to set SRC");
                                if (!IDebug.enabled) break block21;
                                throwable.printStackTrace();
                            }
                        }
                        if (!bl) {
                            return string;
                        }
                        try {
                            CECPropertyDialog.setMemoryPanelElements(cECPropertyBean, pICECDataBean, mOXContainerObj, hashtable);
                        }
                        catch (Throwable throwable) {
                            string = CECPropertyDialog.addMessage(string, throwable);
                            CECPropertyDialog.debugThis("Failed to set memory panel elements");
                            if (!IDebug.enabled) break block22;
                            throwable.printStackTrace();
                        }
                    }
                    try {
                        CECPropertyDialog.setProcessorPanelElements(cECPropertyBean, pICECDataBean, mOXContainerObj, hashtable, auimlAdapter);
                    }
                    catch (Throwable throwable) {
                        string = CECPropertyDialog.addMessage(string, throwable);
                        CECPropertyDialog.debugThis("Failed to set processor elements");
                        if (!IDebug.enabled) break block23;
                        throwable.printStackTrace();
                    }
                }
                try {
                    CECPropertyDialog.setIOPanelElements(cECPropertyBean, pICECDataBean);
                }
                catch (Throwable throwable) {
                    string = CECPropertyDialog.addMessage(string, throwable);
                    CECPropertyDialog.debugThis("Failed to bring up CEC Property Dialog");
                    if (!IDebug.enabled) break block24;
                    throwable.printStackTrace();
                }
            }
            return string;
        }
        catch (Throwable throwable) {
            string = CECPropertyDialog.addMessage(string, throwable);
            if (IDebug.enabled) {
                System.err.println("**** MKS: ERROR -- " + throwable.getMessage());
                throwable.printStackTrace();
            }
            return string;
        }
    }

    private static void setGeneralPanelElements(MOXContainerObj mOXContainerObj, CECPropertyBean cECPropertyBean, PICECDataBean pICECDataBean, AuimlAdapter auimlAdapter, Hashtable hashtable) throws Throwable {
        cECPropertyBean.setCECName(CECPropertyDialog.getStringFromMethod(pICECDataBean, "getUserDefinedName"));
        String string = CECPropertyDialog.getStringFromMethod(pICECDataBean, "getCecState");
        int n = GeneralUtil.getIntValue(string);
        CECPropertyDialog.debugThis("CEC STATE " + n);
        cECPropertyBean.setCECState(CSPStateText.getStateValue(n));
        cECPropertyBean.setModelType(CECPropertyDialog.getStringFromMethod(pICECDataBean, "getTypeModel"));
        cECPropertyBean.setSerialNumber(CECPropertyDialog.getStringFromMethod(pICECDataBean, "getSerial"));
        cECPropertyBean.setServiceProcessorVersion(CECPropertyDialog.getStringFromMethod(pICECDataBean, "getFspFirmwareLevel"));
        cECPropertyBean.setMaxNumOfPartitions(CECPropertyDialog.getStringFromMethod(pICECDataBean, "getNumberOfLPARSlots"));
        cECPropertyBean.setSysAttnLed(CECPropertyDialog.getStringFromMethod(pICECDataBean, "getSysAttnLed"));
        String string2 = CECPropertyDialog.getStringFromMethod(pICECDataBean, "getServicePartition");
        String string3 = CECPropertyDialog.getStringFromMethod(pICECDataBean, "getServicePartitionName");
        String string4 = HSCResourceBundleUtil.getMessage("LPARBundle", "UNASSIGNED");
        if (string3 != null && !string3.equals("")) {
            string4 = string2 + "  --  " + string3;
        }
        CECPropertyDialog.debugThis(" Service Partion = " + string4);
        CECPropertyDialog.setServicePartitionList(cECPropertyBean, pICECDataBean, mOXContainerObj, hashtable);
        cECPropertyBean.setServicePartition(string4);
        cECPropertyBean.setPowerOffPolicy(!CECPropertyDialog.getbooleanFromMethod(pICECDataBean, "getPowerOffPolicy", auimlAdapter));
        Vector vector = CECPropertyDialog.getListsFromNodeCapability(mOXContainerObj, pICECDataBean);
        if (vector != null) {
            ItemDescriptor[] itemDescriptorArray = (ItemDescriptor[])vector.elementAt(0);
            ItemDescriptor[] itemDescriptorArray2 = (ItemDescriptor[])vector.elementAt(1);
            cECPropertyBean.setCapabilityColumnList(itemDescriptorArray);
            cECPropertyBean.setCapabilityValueColumnList(itemDescriptorArray2);
        }
    }

    private static void setFSPAttributes(CECPropertyBean cECPropertyBean, PICECDataBean pICECDataBean, AuimlAdapter auimlAdapter) {
        block11: {
            block10: {
                int n;
                block9: {
                    try {
                        n = GeneralUtil.getIntFromMethod(pICECDataBean, "getPlatformCurrFspBootAttributes");
                        if (n >= 0) {
                            auimlAdapter.setValue("IPLPanel.FSPBootAdvanceInfoPanel.FSPBootAttributesLabel", Integer.toHexString(n));
                        }
                    }
                    catch (Exception exception) {
                        if (!IDebug.enabled) break block9;
                        exception.printStackTrace();
                    }
                }
                try {
                    n = GeneralUtil.getIntFromMethod(pICECDataBean, "getPlatformCurrFspBootMajorType");
                    if (n >= 0) {
                        auimlAdapter.setValue("IPLPanel.FSPBootAdvanceInfoPanel.FSPBootMajorTypeLabel", Integer.toHexString(n));
                    }
                }
                catch (Exception exception) {
                    if (!IDebug.enabled) break block10;
                    exception.printStackTrace();
                }
            }
            try {
                int n = GeneralUtil.getIntFromMethod(pICECDataBean, "getPlatformCurrFspBootMinorType");
                if (n >= 0) {
                    auimlAdapter.setValue("IPLPanel.FSPBootAdvanceInfoPanel.FSPBootMinorTypeLabel", Integer.toHexString(n));
                }
            }
            catch (Exception exception) {
                if (!IDebug.enabled) break block11;
                exception.printStackTrace();
            }
        }
    }

    private static void setIPLPanelElements(CECPropertyBean cECPropertyBean, PICECDataBean pICECDataBean, AuimlAdapter auimlAdapter) throws Throwable {
        CECPropertyDialog.setKeylockValue(cECPropertyBean, pICECDataBean, auimlAdapter);
        CECPropertyDialog.setOS400IPLSource(cECPropertyBean, pICECDataBean, auimlAdapter);
        CECPropertyDialog.setAIXLinuxBootMode(cECPropertyBean, pICECDataBean, auimlAdapter);
        CECPropertyDialog.setIPLSide(cECPropertyBean, pICECDataBean, auimlAdapter);
        CECPropertyDialog.setIPLSpeed(cECPropertyBean, pICECDataBean, auimlAdapter);
        CECPropertyDialog.setIPLSpeedOverride(cECPropertyBean, pICECDataBean, auimlAdapter);
        CECPropertyDialog.setPowerOnOption(cECPropertyBean, pICECDataBean, auimlAdapter);
        CECPropertyDialog.setPowerOnType(cECPropertyBean, pICECDataBean, auimlAdapter);
        CECPropertyDialog.setPowerOnMethod(cECPropertyBean, pICECDataBean, auimlAdapter);
        CECPropertyDialog.setPowerOnAttributes(cECPropertyBean, pICECDataBean, auimlAdapter);
        CECPropertyDialog.setFSPAttributes(cECPropertyBean, pICECDataBean, auimlAdapter);
    }

    private static void setMemoryPanelElements(CECPropertyBean cECPropertyBean, PICECDataBean pICECDataBean, MOXContainerObj mOXContainerObj, Hashtable hashtable) throws Throwable {
        CECPropertyDialog.setCoDMemoryValues(cECPropertyBean, pICECDataBean, mOXContainerObj);
        String string = " " + HSCResourceBundleUtil.getMessage("DLPARBundle", "GB_LABEL");
        String string2 = " " + HSCResourceBundleUtil.getMessage("DLPARBundle", "MB_LABEL");
        cECPropertyBean.setAvailableMemory(CECPropertyDialog.getStringFromMethod(pICECDataBean, "getPendAvailableMemory") + string2);
        cECPropertyBean.setConfigurableMemory(CECPropertyDialog.getStringFromMethod(pICECDataBean, "getConfigurableMemory") + string2);
        int n = GeneralUtil.getIntValue(CECPropertyDialog.getStringFromMethod(pICECDataBean, "getMemoryRegionSize"));
        cECPropertyBean.setMemoryRegionSize(n + string2);
        int n2 = GeneralUtil.getIntValue(CECPropertyDialog.getStringFromMethod(pICECDataBean, "getConfigurableMemory"));
        int n3 = GeneralUtil.getIntValue(CECPropertyDialog.getStringFromMethod(pICECDataBean, "getHypervisorMemory"));
        cECPropertyBean.setCurrentAvailMem(Integer.toString(n2 - n3) + string2);
        CECPropertyDialog.setMemoryTable(cECPropertyBean, pICECDataBean, mOXContainerObj, n, hashtable);
    }

    private static void setProcessorPanelElements(CECPropertyBean cECPropertyBean, PICECDataBean pICECDataBean, MOXContainerObj mOXContainerObj, Hashtable hashtable, AuimlAdapter auimlAdapter) throws Throwable {
        CECPropertyDialog.setCoDProcValues(cECPropertyBean, pICECDataBean, mOXContainerObj);
        double d = (double)pICECDataBean.getCurAvailableProcUnits().intValue() / 100.0;
        cECPropertyBean.setTotalAvailableProcessorUnits(d + "");
        double d2 = (double)pICECDataBean.getConfigurableProcUnits().intValue() / 100.0;
        String string = d2 + "";
        System.out.println("<><><><><> ANN:  prtString (confProcUnits) = " + string);
        cECPropertyBean.setConfigurableProcessors(d2 + "");
        double d3 = (double)pICECDataBean.getMaxI5OSProcUnits().intValue() / 100.0;
        string = d3 + "";
        System.out.println("<><><><><> ANN:  prtString (maxI5OSProcUnits) = " + string);
        cECPropertyBean.setMaxI5OSProcUnits(d3 + "");
        double d4 = (double)pICECDataBean.getMinProcUnitsPerVirtualProc().intValue() / 100.0;
        cECPropertyBean.setMinimumProcUnitsPerProcessor(d4 + "");
        cECPropertyBean.setMaximumSharedPools(CECPropertyDialog.getStringFromMethod(pICECDataBean, "getMaxProcPools"));
        CECPropertyDialog.setProcessorTable(cECPropertyBean, pICECDataBean, mOXContainerObj, hashtable, auimlAdapter);
    }

    private static void setIOPanelElements(CECPropertyBean cECPropertyBean, PICECDataBean pICECDataBean) throws Throwable {
        Hashtable hashtable = new Hashtable();
        TreeTableDisplay[] treeTableDisplayArray = null;
        treeTableDisplayArray = cECPropertyBean.buildIoTables(hashtable);
        if (null != treeTableDisplayArray) {
            cECPropertyBean.initIOHash(treeTableDisplayArray, hashtable);
        }
        cECPropertyBean.setMaxVLANsPerPort(CECPropertyDialog.getStringFromMethod(pICECDataBean, "getMaxVLANIDsPerPort"));
    }

    private static void setSRCPanelElements(CecSrcBean cecSrcBean, MOXContainerObj mOXContainerObj, AuimlAdapter auimlAdapter) {
        Vector vector;
        block4: {
            MOClass mOClass = mOXContainerObj.getMOClass();
            vector = null;
            try {
                Object[] objectArray = new Object[]{mOXContainerObj, new Long(-1L), new Integer(0)};
                vector = (Vector)mOClass.invokeStaticMethod(SRC_FUNC, objectArray);
            }
            catch (Exception exception) {
                if (!IDebug.enabled()) break block4;
                System.err.println("Exeption caught retrieving current SRC..");
                exception.printStackTrace();
            }
        }
        if (vector != null) {
            HashMap<String, SRCEntry> hashMap = new HashMap<String, SRCEntry>();
            SRCEntry sRCEntry = (SRCEntry)vector.elementAt(0);
            String string = sRCEntry.getSrcSeqNum();
            String string2 = sRCEntry.getDefaultDisplay();
            ItemDescriptor itemDescriptor = new ItemDescriptor(string, string);
            cecSrcBean.setSRCNumberList(new ItemDescriptor[]{itemDescriptor});
            itemDescriptor = new ItemDescriptor(string2, string2);
            cecSrcBean.setSRCStringList(new ItemDescriptor[]{itemDescriptor});
            cecSrcBean.setCurrentSRC(string);
            hashMap.put(string, sRCEntry);
            cecSrcBean.setSRCMap(hashMap);
        } else {
            cecSrcBean.setCurrentSRC("0");
        }
        cecSrcBean.setUTM(auimlAdapter.getUserTaskManager());
        cecSrcBean.setMObj(mOXContainerObj);
    }

    private static String getStringFromMethod(PICECDataBean pICECDataBean, String string) throws Throwable {
        Method method = pICECDataBean.getClass().getMethod(string, null);
        Object object = method.invoke((Object)pICECDataBean, null);
        CECPropertyDialog.debugThis(" Method Name " + string);
        CECPropertyDialog.debugThis(" Value  " + object);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof UnsignedInt32) {
            return ((UnsignedInt32)object).toString();
        }
        if (object instanceof UnsignedInt16) {
            return ((UnsignedInt16)object).toString();
        }
        if (object instanceof UnsignedInt8) {
            return ((UnsignedInt8)object).toString();
        }
        if (object instanceof Boolean && object != null) {
            if (((Boolean)object).booleanValue()) {
                return HSCResourceBundleUtil.getMessage("SFPResourceBundle", "LED_STATE_ON");
            }
            return HSCResourceBundleUtil.getMessage("SFPResourceBundle", "LED_STATE_OFF");
        }
        return "";
    }

    private static boolean getbooleanFromMethod(PICECDataBean pICECDataBean, String string, AuimlAdapter auimlAdapter) throws Throwable {
        Method method = pICECDataBean.getClass().getMethod(string, null);
        Boolean bl = (Boolean)method.invoke((Object)pICECDataBean, null);
        CECPropertyDialog.debugThis(" Method Name " + string);
        CECPropertyDialog.debugThis(" Value  " + bl);
        if (bl != null) {
            return bl;
        }
        auimlAdapter.setEnabled("MachinePanel.PowerOffCheckBox", false);
        return true;
    }

    private static void setOS400IPLSource(CECPropertyBean cECPropertyBean, PICECDataBean pICECDataBean, AuimlAdapter auimlAdapter) {
        block2: {
            try {
                int n = GeneralUtil.getIntFromMethod(pICECDataBean, "getPlatformCurrFspmOsIplMode");
                auimlAdapter.setValue("IPLPanel.OS400IPLSourceLabel", "" + CECPropertyDialog.getOS400IplSource(n));
                int n2 = GeneralUtil.getIntFromMethod(pICECDataBean, "getPlatformNextFspmOsIplMode");
                ValueDescriptor[] valueDescriptorArray = new ValueDescriptor[]{new ValueDescriptor("OS400A", "A"), new ValueDescriptor("OS400B", "B"), new ValueDescriptor("OS400C", "C"), new ValueDescriptor("OS400D", "D")};
                String string = CECPropertyDialog.getOS400IplSource(n2);
                cECPropertyBean.setOSIPLSourceList(valueDescriptorArray);
                cECPropertyBean.setOSIPLSource(string);
            }
            catch (Exception exception) {
                if (!IDebug.enabled) break block2;
                exception.printStackTrace();
            }
        }
    }

    private static void setAIXLinuxBootMode(CECPropertyBean cECPropertyBean, PICECDataBean pICECDataBean, AuimlAdapter auimlAdapter) {
        block3: {
            try {
                int n = GeneralUtil.getIntFromMethod(pICECDataBean, "getPlatformCurrFspmLparBootMode");
                String[] stringArray = new String[5];
                ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.hsc.auiml.databeans.profile.LparProfWizard");
                stringArray[0] = GeneralUtil.removePercentSign(resourceBundle.getString("ProfileP08Other.NormalModeButton.TEXT"));
                stringArray[1] = GeneralUtil.removePercentSign(resourceBundle.getString("ProfileP08Other.SMSModeButton.TEXT"));
                stringArray[2] = GeneralUtil.removePercentSign(resourceBundle.getString("ProfileP08Other.DiagModeButton.TEXT"));
                stringArray[3] = GeneralUtil.removePercentSign(resourceBundle.getString("ProfileP08Other.DiagStoredModeButton.TEXT"));
                stringArray[4] = GeneralUtil.removePercentSign(resourceBundle.getString("ProfileP08Other.OpenFirmWModeButton.TEXT"));
                auimlAdapter.setValue("IPLPanel.AIXLinuxBootModeLabel", CECPropertyDialog.getAIXLinuxBootMode(n, stringArray));
                int n2 = GeneralUtil.getIntFromMethod(pICECDataBean, "getPlatformNextFspmLparBootMode");
                ValueDescriptor[] valueDescriptorArray = new ValueDescriptor[5];
                for (int i = 0; i < 5; ++i) {
                    valueDescriptorArray[i] = new ValueDescriptor(stringArray[i] + i, stringArray[i]);
                }
                String string = CECPropertyDialog.getAIXLinuxBootMode(n2, stringArray);
                cECPropertyBean.setAIXLinuxBootModeList(valueDescriptorArray);
                cECPropertyBean.setAIXLinuxBootMode(string);
            }
            catch (Exception exception) {
                if (!IDebug.enabled) break block3;
                exception.printStackTrace();
            }
        }
    }

    private static String getIPLState(PICECDataBean pICECDataBean) {
        int n;
        block5: {
            UnsignedInt8 unsignedInt8 = pICECDataBean.getPlatformCurrHypervisorIplState();
            n = -1;
            try {
                n = unsignedInt8.intValue();
            }
            catch (NullPointerException nullPointerException) {
                if (!IDebug.enabled) break block5;
                nullPointerException.printStackTrace();
            }
        }
        String string = CECPropertyDialog.getMessage("IPL_TO_STANDBY");
        String string2 = CECPropertyDialog.getMessage("IPL_TO_RUNNING");
        String string3 = "";
        CECPropertyDialog.debugThis(" IPL State  " + n);
        if (n == 1) {
            string3 = string;
        } else if (n == 2) {
            string3 = string2;
        }
        return string3;
    }

    private static String getFSPIPLAttributes(PICECDataBean pICECDataBean) {
        int n;
        block5: {
            UnsignedInt16 unsignedInt16 = pICECDataBean.getPlatformCurrFspBootAttributes();
            n = -1;
            try {
                n = unsignedInt16.intValue();
            }
            catch (NullPointerException nullPointerException) {
                if (!IDebug.enabled) break block5;
                nullPointerException.printStackTrace();
            }
        }
        String string = CECPropertyDialog.getMessage("CODE_UPDATED_FROM_LAST_BOOT");
        String string2 = CECPropertyDialog.getMessage("FSP_CONTROL_STORE_PRESERVED");
        String string3 = "";
        CECPropertyDialog.debugThis(" FSP IPL Attr Value  " + n);
        if ((n & 0x4000) != 0) {
            string3 = string;
        } else if ((n & 0x1000) != 0) {
            string3 = string2;
        }
        return string3;
    }

    private static Vector getListsFromNodeCapability(MOXContainerObj mOXContainerObj, PICECDataBean pICECDataBean) {
        ItemDescriptor[] itemDescriptorArray;
        ItemDescriptor[] itemDescriptorArray2;
        UnsignedInt32 unsignedInt32 = pICECDataBean.getNodeCapability();
        if (unsignedInt32 == null) {
            if (IDebug.enabled) {
                System.err.println("ERROR: Failed to get Node capability");
            }
            return null;
        }
        byte[] byArray = ByteUtilities.intToByteArray(unsignedInt32.intValue());
        BitSet bitSet = ByteUtilities.byteArrayToBitSet(byArray);
        boolean bl = false;
        if (bitSet.get(28)) {
            bl = true;
        }
        String string = CECPropertyDialog.getMessage("SMA_CAPABLE");
        String string2 = CECPropertyDialog.getMessage("CUOD_CAPABLE");
        String string3 = CECPropertyDialog.getMessage("COD_PROC_CAPABLE");
        String string4 = CECPropertyDialog.getMessage("COD_MEM_CAPABLE");
        String string5 = CECPropertyDialog.getMessage("OS400_CAPABLE");
        String string6 = CECPropertyDialog.getMessage("HSL_CAPABLE");
        String string7 = CECPropertyDialog.getMessage("FOD_CAPABLE");
        String string8 = CECPropertyDialog.getMessage("IO_SERVER_CAPABLE");
        String string9 = CECPropertyDialog.getMessage("APPLICATION_5250_CAPABLE");
        Vector<ItemDescriptor[]> vector = new Vector<ItemDescriptor[]>();
        int n = 0;
        int n2 = unsignedInt32.intValue();
        CECPropertyDialog.debugThis(" Capability Value  " + n2);
        boolean bl2 = false;
        BitSet bitSet2 = (BitSet)mOXContainerObj.getPropertyValue("CodCapabilities_PROP");
        if ((n2 & 0x40000000) != 0 && pICECDataBean.is5250CapabilityKnown()) {
            n = 1;
        }
        if ((n2 & 0x20000000) != 0) {
            itemDescriptorArray2 = new ItemDescriptor[6 + n];
            itemDescriptorArray = new ItemDescriptor[6 + n];
            itemDescriptorArray[1 + n] = new ItemDescriptor("CUoDCapableVal", TRUE);
            itemDescriptorArray2[2 + n] = new ItemDescriptor("CoDProcCapable", "   " + string3);
            itemDescriptorArray2[3 + n] = new ItemDescriptor("CoDMemCapable", "   " + string4);
            itemDescriptorArray2[4 + n] = new ItemDescriptor("FoDCapable", string7);
            itemDescriptorArray2[5 + n] = new ItemDescriptor("IOServerCapableName", string8);
            itemDescriptorArray[2 + n] = bitSet2.get(0) ? new ItemDescriptor("CoDProcCapableVal", TRUE) : new ItemDescriptor("CoDProcCapableVal", FALSE);
            itemDescriptorArray[3 + n] = bitSet2.get(1) ? new ItemDescriptor("CoDMemCapableVal", TRUE) : new ItemDescriptor("CoDMemCapableVal", FALSE);
            itemDescriptorArray[4 + n] = bl ? new ItemDescriptor("FoDCapableVal", TRUE) : new ItemDescriptor("FoDCapableVal", FALSE);
            itemDescriptorArray[5 + n] = pICECDataBean.isIOServerCapable() ? new ItemDescriptor("IOServerCapableVal", TRUE) : new ItemDescriptor("IOServerCapableVal", FALSE);
        } else {
            itemDescriptorArray2 = new ItemDescriptor[4];
            itemDescriptorArray = new ItemDescriptor[4];
            itemDescriptorArray[1 + n] = new ItemDescriptor("CUoDCapableVal", FALSE);
            itemDescriptorArray2[2 + n] = new ItemDescriptor("FoDCapableName", string7);
            itemDescriptorArray2[3 + n] = new ItemDescriptor("IOServerCapableName", string8);
            itemDescriptorArray[2 + n] = bl ? new ItemDescriptor("FoDCapableVal", TRUE) : new ItemDescriptor("FoDCapableVal", FALSE);
            itemDescriptorArray[3 + n] = pICECDataBean.isIOServerCapable() ? new ItemDescriptor("IOServerCapableVal", TRUE) : new ItemDescriptor("IOServerCapableVal", FALSE);
        }
        itemDescriptorArray2[0] = new ItemDescriptor("OS400CapableName", string5);
        itemDescriptorArray2[1 + n] = new ItemDescriptor("CUoDCapableName", string2);
        itemDescriptorArray[0] = (n2 & 0x40000000) != 0 ? new ItemDescriptor("OS400CapableVal", TRUE) : new ItemDescriptor("OS400CapableVal", FALSE);
        if (n != 0) {
            itemDescriptorArray2[1] = new ItemDescriptor("5250ApplicationCapable", "   " + string9);
            itemDescriptorArray[1] = pICECDataBean.is5250Capable() ? new ItemDescriptor("5250ApplicationCapableVal", TRUE) : new ItemDescriptor("5250ApplicationCapableVal", FALSE);
        }
        vector.add(itemDescriptorArray2);
        vector.add(itemDescriptorArray);
        return vector;
    }

    private static int getIPLValue(UnsignedInt8 unsignedInt8) {
        int n;
        block2: {
            n = -1;
            try {
                n = unsignedInt8.intValue();
                CECPropertyDialog.debugThis(" IPL Value  " + n);
            }
            catch (Exception exception) {
                if (!IDebug.enabled) break block2;
                exception.printStackTrace();
            }
        }
        return n;
    }

    private static void setPowerOnMethod(CECPropertyBean cECPropertyBean, PICECDataBean pICECDataBean, AuimlAdapter auimlAdapter) {
        block2: {
            try {
                int n = GeneralUtil.getIntFromMethod(pICECDataBean, "getPlatformCurrCecIplMinorType");
                auimlAdapter.setValue("IPLPanel.FSPBootAdvanceInfoPanel.PowerOnMethodLabel", Integer.toHexString(n));
            }
            catch (Exception exception) {
                if (!IDebug.enabled) break block2;
                exception.printStackTrace();
            }
        }
    }

    private static void setPowerOnAttributes(CECPropertyBean cECPropertyBean, PICECDataBean pICECDataBean, AuimlAdapter auimlAdapter) {
        block2: {
            try {
                int n = GeneralUtil.getIntFromMethod(pICECDataBean, "getPlatformCurrCecIplAttributes");
                auimlAdapter.setValue("IPLPanel.FSPBootAdvanceInfoPanel.PowerOnAttrLabel", Integer.toHexString(n));
            }
            catch (Exception exception) {
                if (!IDebug.enabled) break block2;
                exception.printStackTrace();
            }
        }
    }

    private static void setPowerOnOption(CECPropertyBean cECPropertyBean, PICECDataBean pICECDataBean, AuimlAdapter auimlAdapter) {
        block3: {
            try {
                int n = GeneralUtil.getIntFromMethod(pICECDataBean, "getPlatformCurrHypervisorIplState");
                if (n < -1) {
                    return;
                }
                String string = CECPropertyDialog.getMessage("CEC_STANDBY");
                String string2 = CECPropertyDialog.getMessage("AUTOSTART");
                String string3 = n == 1 ? string : string2;
                auimlAdapter.setValue("IPLPanel.PowerOnOptionLabel", string3);
            }
            catch (Exception exception) {
                if (!IDebug.enabled) break block3;
                exception.printStackTrace();
            }
        }
    }

    private static void setPowerOnType(CECPropertyBean cECPropertyBean, PICECDataBean pICECDataBean, AuimlAdapter auimlAdapter) {
        block3: {
            try {
                int n = GeneralUtil.getIntFromMethod(pICECDataBean, "getPlatformCurrCecIplMajorType");
                if (n < -1) {
                    return;
                }
                String string = CECPropertyDialog.getMessage("POWERON");
                String string2 = CECPropertyDialog.getMessage("RESTART");
                String string3 = n == 1 ? string2 : string;
                auimlAdapter.setValue("IPLPanel.PowerOnTypeLabel", string3);
            }
            catch (Exception exception) {
                if (!IDebug.enabled) break block3;
                exception.printStackTrace();
            }
        }
    }

    private static void setIPLSide(CECPropertyBean cECPropertyBean, PICECDataBean pICECDataBean, AuimlAdapter auimlAdapter) {
        block4: {
            try {
                UnsignedInt8 unsignedInt8 = pICECDataBean.getPlatformCurrIplSide();
                CECPropertyDialog.debugThis("Cur IPL Side " + unsignedInt8);
                int n = CECPropertyDialog.getIPLValue(unsignedInt8);
                if (n < 0) {
                    return;
                }
                String string = CECPropertyDialog.getMessage("PERMANENT");
                String string2 = CECPropertyDialog.getMessage("TEMPORARY");
                String string3 = "";
                string3 = n == 0 ? string : string2;
                auimlAdapter.setValue("IPLPanel.FSPBootAdvanceInfoPanel.PowerOnSideLabel", string3);
                ValueDescriptor[] valueDescriptorArray = new ValueDescriptor[2];
                UnsignedInt8 unsignedInt82 = pICECDataBean.getPlatformNextIplSide();
                CECPropertyDialog.debugThis("Next IPL Side " + unsignedInt82);
                n = CECPropertyDialog.getIPLValue(unsignedInt82);
                if (n < 0) {
                    return;
                }
                string3 = n == 0 ? string : string2;
                valueDescriptorArray[0] = new ValueDescriptor("IPLSide" + string, string);
                valueDescriptorArray[1] = new ValueDescriptor("IPLSide" + string2, string2);
                cECPropertyBean.setIPLSideList(valueDescriptorArray);
                cECPropertyBean.setIPLSide(string3);
            }
            catch (Exception exception) {
                if (!IDebug.enabled) break block4;
                exception.printStackTrace();
            }
        }
    }

    private static void setIPLSpeed(CECPropertyBean cECPropertyBean, PICECDataBean pICECDataBean, AuimlAdapter auimlAdapter) {
        block4: {
            try {
                UnsignedInt8 unsignedInt8 = pICECDataBean.getPlatformCurrIplSpeed();
                CECPropertyDialog.debugThis("Cur IPL Speed " + unsignedInt8);
                int n = CECPropertyDialog.getIPLValue(unsignedInt8);
                if (n < 0) {
                    return;
                }
                String string = CECPropertyDialog.getMessage("SLOW");
                String string2 = CECPropertyDialog.getMessage("FAST");
                String string3 = "";
                string3 = n == 16 ? string : string2;
                auimlAdapter.setValue("IPLPanel.FSPBootAdvanceInfoPanel.PowerOnSpeedLabel", string3);
                ValueDescriptor[] valueDescriptorArray = new ValueDescriptor[2];
                UnsignedInt8 unsignedInt82 = pICECDataBean.getPlatformNextIplSpeed();
                CECPropertyDialog.debugThis("Next IPL Speed " + unsignedInt82);
                n = CECPropertyDialog.getIPLValue(unsignedInt82);
                if (n < 0) {
                    return;
                }
                string3 = n == 16 ? string : string2;
                valueDescriptorArray[0] = new ValueDescriptor("IPLSpeed" + string, string);
                valueDescriptorArray[1] = new ValueDescriptor("IPLSpeed" + string2, string2);
                cECPropertyBean.setIPLSpeedList(valueDescriptorArray);
                cECPropertyBean.setIPLSpeed(string3);
            }
            catch (Exception exception) {
                if (!IDebug.enabled) break block4;
                exception.printStackTrace();
            }
        }
    }

    private static void setIPLSpeedOverride(CECPropertyBean cECPropertyBean, PICECDataBean pICECDataBean, AuimlAdapter auimlAdapter) {
        block4: {
            try {
                UnsignedInt8 unsignedInt8 = pICECDataBean.getPlatformCurrIplSpeedOverride();
                CECPropertyDialog.debugThis("Cur IPL Speed Override " + unsignedInt8);
                int n = CECPropertyDialog.getIPLValue(unsignedInt8);
                if (n < 0) {
                    return;
                }
                String string = CECPropertyDialog.getMessage("NO_OVERRIDE");
                String string2 = CECPropertyDialog.getMessage("SLOW");
                String string3 = CECPropertyDialog.getMessage("FAST");
                String string4 = "";
                string4 = n == 0 ? string : (n == 16 ? string2 : string3);
                auimlAdapter.setValue("IPLPanel.FSPBootAdvanceInfoPanel.PowerOnSpeedOverrideLabel", string4);
                ValueDescriptor[] valueDescriptorArray = new ValueDescriptor[3];
                UnsignedInt8 unsignedInt82 = pICECDataBean.getPlatformNextIplSpeedOverride();
                CECPropertyDialog.debugThis("Next IPL Speed Override " + unsignedInt82);
                n = CECPropertyDialog.getIPLValue(unsignedInt82);
                if (n < 0) {
                    return;
                }
                string4 = n == 0 ? string : (n == 16 ? string2 : string3);
                valueDescriptorArray[0] = new ValueDescriptor("IPLSpeedOverride" + string2, string2);
                valueDescriptorArray[1] = new ValueDescriptor("IPLSpeedOverride" + string3, string3);
                valueDescriptorArray[2] = new ValueDescriptor("IPLSpeedOverride" + string, string);
                cECPropertyBean.setIPLSpeedOverrideList(valueDescriptorArray);
                cECPropertyBean.setIPLSpeedOverride(string4);
            }
            catch (Exception exception) {
                if (!IDebug.enabled) break block4;
                exception.printStackTrace();
            }
        }
    }

    private static void setProcessorTable(CECPropertyBean cECPropertyBean, PICECDataBean pICECDataBean, MOXContainerObj mOXContainerObj, Hashtable hashtable, AuimlAdapter auimlAdapter) {
        try {
            Vector vector = (Vector)hashtable.get("partitionproclist");
            if (vector == null) {
                CECPropertyDialog.debugThis("Partition is null in setProcessorTable");
                return;
            }
            boolean bl = false;
            try {
                bl = pICECDataBean.getAllowHMCAssignCPW();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ItemDescriptor[] itemDescriptorArray = new ItemDescriptor[vector.size()];
            ItemDescriptor[] itemDescriptorArray2 = new ItemDescriptor[vector.size()];
            ItemDescriptor[] itemDescriptorArray3 = new ItemDescriptor[vector.size()];
            ItemDescriptor[] itemDescriptorArray4 = null;
            if (bl) {
                itemDescriptorArray4 = new ItemDescriptor[vector.size()];
            } else {
                auimlAdapter.setShown("ProcessorPanel.AvailableInteractiveColumn", false);
            }
            int n = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String[] stringArray = (String[])enumeration.nextElement();
                itemDescriptorArray[n] = new ItemDescriptor("ProcName" + n, stringArray[0]);
                itemDescriptorArray2[n] = new ItemDescriptor("ProcValue" + n, stringArray[1]);
                itemDescriptorArray3[n] = new ItemDescriptor("ProcMode" + n, stringArray[2]);
                if (bl) {
                    itemDescriptorArray4[n] = new ItemDescriptor("ProcInteractive" + n, stringArray[3]);
                }
                CECPropertyDialog.debugThis("PartitionName  is " + itemDescriptorArray[n]);
                CECPropertyDialog.debugThis("Proc Value  is " + itemDescriptorArray2[n]);
                CECPropertyDialog.debugThis("Proc Mode  is " + itemDescriptorArray3[n]);
                if (bl) {
                    CECPropertyDialog.debugThis("Proc Avail Interactive is " + itemDescriptorArray4[n]);
                }
                ++n;
            }
            cECPropertyBean.setProcTablePartitionNameColumnList(itemDescriptorArray);
            cECPropertyBean.setProcTableProcessorUnitsColumnList(itemDescriptorArray2);
            cECPropertyBean.setProcTableProcessorModeColumnList(itemDescriptorArray3);
            if (bl) {
                cECPropertyBean.setProcTableAvailableInteractiveColumnList(itemDescriptorArray4);
            }
        }
        catch (Exception exception) {
            if (IDebug.enabled) {
                System.out.println("Failed to get CEC DataBean");
                exception.printStackTrace();
            }
            String string = HSCResourceBundleUtil.getMessage("CECBundle", "GET_PROC_TABLE_ERROR_TITLE");
            String string2 = HSCResourceBundleUtil.getMessage("CECBundle", "GET_PROC_TABLE_ERROR");
            HSCLogUtils.clientLog(exception, HSCLogUtils._CECClassLogInfo);
        }
    }

    private static void setMemoryTable(CECPropertyBean cECPropertyBean, PICECDataBean pICECDataBean, MOXContainerObj mOXContainerObj, int n, Hashtable hashtable) {
        try {
            Object[] objectArray = new Object[]{};
            Vector vector = (Vector)hashtable.get("partitionmemlist");
            ItemDescriptor[] itemDescriptorArray = new ItemDescriptor[vector.size()];
            ItemDescriptor[] itemDescriptorArray2 = new ItemDescriptor[vector.size()];
            int n2 = 0;
            if (vector == null) {
                CECPropertyDialog.debugThis("Partition is null in setMemoryTable");
                return;
            }
            CECPropertyDialog.debugThis("Size is " + vector.size());
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String[] stringArray = (String[])enumeration.nextElement();
                CECPropertyDialog.debugThis("PartitionName  is " + stringArray[0]);
                CECPropertyDialog.debugThis("Mem Value  is " + stringArray[1]);
                itemDescriptorArray[n2] = new ItemDescriptor("MemName" + n2, stringArray[0]);
                int n3 = GeneralUtil.getIntValue(stringArray[1]);
                String string = n3 + "";
                itemDescriptorArray2[n2] = new ItemDescriptor("MemValue" + n2, string);
                ++n2;
            }
            cECPropertyBean.setMemTablePartitionNameColumnList(itemDescriptorArray);
            cECPropertyBean.setMemTableAmountOfMemoryColumnList(itemDescriptorArray2);
        }
        catch (Exception exception) {
            if (IDebug.enabled) {
                System.out.println("Failed to get CEC DataBean");
                exception.printStackTrace();
            }
            String string = HSCResourceBundleUtil.getMessage("CECBundle", "GET_MEM_TABLE_ERROR_TITLE");
            String string2 = HSCResourceBundleUtil.getMessage("CECBundle", "GET_MEM_TABLE_ERROR");
            HSCLogUtils.clientLog(exception, HSCLogUtils._CECClassLogInfo);
        }
    }

    private static void setKeylockValue(CECPropertyBean cECPropertyBean, PICECDataBean pICECDataBean, AuimlAdapter auimlAdapter) throws Throwable {
        int n = GeneralUtil.getIntFromMethod(pICECDataBean, "getPlatformCurrKeylockPos");
        if (n < 0) {
            CECPropertyDialog.debugThis(" Invalid value for cur Keylock " + n);
            return;
        }
        String string = CECPropertyDialog.getMessage("MANUAL_BOOT", "LPARBundle");
        String string2 = CECPropertyDialog.getMessage("NORMAL_BOOT", "LPARBundle");
        String string3 = "";
        CECPropertyDialog.debugThis("Key lock value " + n);
        if (n == 2) {
            string3 = string;
        } else if (n == 4) {
            string3 = string2;
        }
        auimlAdapter.setValue("IPLPanel.KeylockPositionCurrentLabel", string3);
        n = GeneralUtil.getIntFromMethod(pICECDataBean, "getPlatformNextKeylockPos");
        if (n < 0) {
            CECPropertyDialog.debugThis(" Invalid value for next Keylock " + n);
            return;
        }
        if (n == 2) {
            string3 = string;
        } else if (n == 4) {
            string3 = string2;
        }
        ValueDescriptor[] valueDescriptorArray = new ValueDescriptor[]{new ValueDescriptor("Keylock" + string, string), new ValueDescriptor("Keylock" + string2, string2)};
        cECPropertyBean.setIPLSystemOperatingModeList(valueDescriptorArray);
        cECPropertyBean.setIPLSystemOperatingMode(string3);
    }

    private static String getMessage(String string) {
        return HSCResourceBundleUtil.getMessage("CECBundle", string);
    }

    private static String getMessage(String string, String string2) {
        return HSCResourceBundleUtil.getMessage(string2, string);
    }

    private static void debugThis(String string) {
        if (IDebug.enabled || debug) {
            System.err.println("------CECPropertyDialog -> " + string);
        }
    }

    private static Object getObjectFromMethod(String string, MOXContainerObj mOXContainerObj) {
        Object object = null;
        try {
            Object[] objectArray = new Object[]{mOXContainerObj, KEYS};
            object = mOXContainerObj.getMOClass().invokeStaticMethod(string, objectArray);
        }
        catch (Throwable throwable) {
            if (IDebug.enabled) {
                System.out.println("Failed to get CEC DataBean");
                throwable.printStackTrace();
            }
            String string2 = HSCResourceBundleUtil.getMessage("CECBundle", "GET_CECDATABEAN_ERROR_TITLE");
            String string3 = HSCResourceBundleUtil.getMessage("CECBundle", "GET_CECDATABEAN_ERROR");
            HSCLogUtils.clientLog(throwable, HSCLogUtils._CECClassLogInfo);
            return object;
        }
        return object;
    }

    private static void setCoDMemoryValues(CECPropertyBean cECPropertyBean, PICECDataBean pICECDataBean, MOXContainerObj mOXContainerObj) {
        try {
            String[] stringArray = new String[]{"installed_mem", "deconfig_mem"};
            String string = " " + HSCResourceBundleUtil.getMessage("DLPARBundle", "MB_LABEL");
            cECPropertyBean.setInstalledMemory(GeneralUtil.getStringFromMethod(pICECDataBean, "getInstalledMemory") + string);
            cECPropertyBean.setDeconfMemory(GeneralUtil.getStringFromMethod(pICECDataBean, "getDeconfigMemory") + string);
        }
        catch (Throwable throwable) {
            if (IDebug.enabled) {
                throwable.printStackTrace();
            }
            String string = "CEC Property Dialog Warning";
            System.err.println("Warning! Cannot get installed and deconfigured memory values");
        }
    }

    private static void setCoDProcValues(CECPropertyBean cECPropertyBean, PICECDataBean pICECDataBean, MOXContainerObj mOXContainerObj) {
        try {
            int n = GeneralUtil.getIntFromMethod(pICECDataBean, "getInstalledProcUnits");
            cECPropertyBean.setInstalledProcUnits(n / 100 + "");
            int n2 = GeneralUtil.getIntFromMethod(pICECDataBean, "getDeconfigProcUnits");
            cECPropertyBean.setDeconfProcUnits((double)n2 / 100.0 + "");
        }
        catch (Throwable throwable) {
            if (IDebug.enabled) {
                throwable.printStackTrace();
            }
            String string = "CEC Property Dialog Warning";
            System.err.println("Warning! Cannot get installed and deconfigured processor unit values");
        }
    }

    private static void setServicePartitionList(CECPropertyBean cECPropertyBean, PICECDataBean pICECDataBean, MOXContainerObj mOXContainerObj, Hashtable hashtable) {
        try {
            Vector vector = (Vector)hashtable.get("partitionlist");
            ValueDescriptor[] valueDescriptorArray = new ValueDescriptor[vector.size() + 1];
            int n = 0;
            if (vector == null) {
                CECPropertyDialog.debugThis("Partition is null in setServicePartitionList");
                return;
            }
            Object object = vector.elements();
            while (object.hasMoreElements()) {
                String[] stringArray = (String[])object.nextElement();
                String string = stringArray[0] + "  --  " + stringArray[1];
                valueDescriptorArray[n] = new ValueDescriptor("ProcLists" + n, string);
                CECPropertyDialog.debugThis("LPAR LIST is " + valueDescriptorArray[n].getTitle());
                cECPropertyBean.setServiceParitionInHashMap(stringArray[0], string);
                ++n;
            }
            object = HSCResourceBundleUtil.getMessage("LPARBundle", "UNASSIGNED");
            valueDescriptorArray[n] = new ValueDescriptor("ProcLists" + n, (String)object);
            cECPropertyBean.setServiceParitionInHashMap("65535", (String)object);
            cECPropertyBean.setServicePartitionList(valueDescriptorArray);
        }
        catch (Exception exception) {
            if (IDebug.enabled) {
                System.out.println("Failed to get CEC DataBean");
                exception.printStackTrace();
            }
            String string = HSCResourceBundleUtil.getMessage("CECBundle", "GET_PROC_TABLE_ERROR_TITLE");
            String string2 = HSCResourceBundleUtil.getMessage("CECBundle", "GET_PROC_TABLE_ERROR");
            HSCLogUtils.clientLog(exception, HSCLogUtils._CECClassLogInfo);
        }
    }

    private static String getAIXLinuxBootMode(int n, String[] stringArray) {
        String string = "";
        if (n == 1) {
            string = stringArray[0];
        } else if (n == 3) {
            string = stringArray[1];
        } else if (n == 5) {
            string = stringArray[2];
        } else if (n == 2) {
            string = stringArray[3];
        } else if (n == 4) {
            string = stringArray[4];
        } else {
            CECPropertyDialog.debugThis("ERROR: OS 400 IPL Source value is wrong " + n);
        }
        return string;
    }

    private static String getOS400IplSource(int n) {
        String string = "";
        if (n == 8) {
            string = "A";
        } else if (n == 9) {
            string = "B";
        } else if (n == 10) {
            string = "C";
        } else if (n == 11) {
            string = "D";
        } else {
            CECPropertyDialog.debugThis("ERROR: OS 400 IPL Source value is wrong " + n);
        }
        return string;
    }

    private static String addMessage(String string, Throwable throwable) {
        String string2 = throwable.getMessage();
        if (string2 != null) {
            string = string + string2 + "\n";
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        properties = new Properties();
        properties.put("@SRCPanel.SRCNumColumn", "DEFAULTWIDTH:40");
        properties.put("@IPLPanel.AIXLinuxBootModeLabel", "INSETBOTTOM:0");
        properties.put("@MachinePanel", "ROWS:13");
        properties.put("@MachinePanel.CECPropLeadIn", "CELL:1,0");
        properties.put("@MachinePanel.CECPropLeadIn.CAPTION", "CELL:0,0");
        properties.put("@MachinePanel.CECStateLabel", "CELL:2,5");
        properties.put("@MachinePanel.CECStateLabel.CAPTION", "CELL:1,5");
        properties.put("@MachinePanel.SysAttnLed", "CELL:2,6");
        properties.put("@MachinePanel.SysAttnLed.CAPTION", "CELL:1,6");
        properties.put("@MachinePanel.Group1", "CELL:1,11");
        properties.put("@MachinePanel.Group2", "CELL:1,10");
        properties.put("@MachinePanel.MaximumNumOfPartitionsLabel", "CELL:2,8");
        properties.put("@MachinePanel.MaximumNumOfPartitionsLabel.CAPTION", "CELL:1,8");
        properties.put("@MachinePanel.ModelTypeLabel", "CELL:2,4");
        properties.put("@MachinePanel.ModelTypeLabel.CAPTION", "CELL:1,4");
        properties.put("@MachinePanel.NameLabel", "CELL:2,1");
        properties.put("@MachinePanel.NameLabel.CAPTION", "CELL:1,1");
        properties.put("@MachinePanel.PowerOffCheckBox", "CELL:0,0");
        properties.put("@MachinePanel.RuntimeCapTable", "CELL:0,0");
        properties.put("@MachinePanel.SerialNumberLabel", "CELL:2,3");
        properties.put("@MachinePanel.SerialNumberLabel.CAPTION", "CELL:1,3");
        properties.put("@MachinePanel.ServicePartitionCB", "CELL:2,9");
        properties.put("@MachinePanel.ServicePartitionCB.CAPTION", "CELL:1,9");
        properties.put("@MachinePanel.ServiceProcessorVersionLabel", "CELL:2,7");
        properties.put("@MachinePanel.ServiceProcessorVersionLabel.CAPTION", "CELL:1,7");
        properties.put("@MachinePanel.String1", "CELL:3,2");
        debug = false;
        KEYS = new String[]{"name", "type_model", "serial_num", "state", "curr_sys_keylock", "pend_sys_keylock", "curr_power_on_side", "pend_power_on_side", "curr_mfg_default_ipl_source", "pend_mfg_default_ipl_source", "curr_power_on_speed", "pend_power_on_speed", "curr_power_on_speed_override", "pend_power_on_speed_override", "power_on_attr", "power_on_type", "power_on_method", "power_on_option", "pend_power_on_option", "curr_mfg_default_boot_mode", "pend_mfg_default_boot_mode", "sp_boot_attr", "sp_boot_major_type", "sp_boot_minor_type", "max_lpars", "hyp_capabilities", "cod_capabilities", "mem_region_size", "max_power_ctrl_lpars", "min_proc_units_per_virtual_proc", "max_shared_proc_pools", "max_io_pools", "max_vlans_per_port", "mac_prefix", "sp_version", "power_off_policy", "service_lpar_id", "service_lpar_name", "installed_sys_mem", "installed_sys_proc_units", "configurable_sys_mem", "configurable_sys_proc_units", "max_os400_proc_units", "sys_firmware_mem", "deconfig_sys_mem", "deconfig_sys_proc_units", "curr_avail_sys_mem", "assign_5250_cpw_percent", "curr_avail_sys_proc_units", "pend_avail_sys_mem", "attn_led"};
    }
}

